from flask_sqlalchemy import SQLAlchemy
from flask_login import UserMixin
from werkzeug.security import generate_password_hash, check_password_hash
from database import db
from datetime import datetime, timezone

class User(UserMixin, db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String(80), unique=True, nullable=False)
    password_hash = db.Column(db.String(128))
    is_admin = db.Column(db.Boolean, default=False)
    completed_tests = db.Column(db.JSON, default={})
    # Add more fields (e.g., email, role) as needed

    def set_password(self, password):
        self.password_hash = generate_password_hash(password)

    def check_password(self, password):
        return check_password_hash(self.password_hash, password)

class TestAttempt(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    __table_args__ = (
        db.UniqueConstraint('user_id', 'test_name', name='uix_user_test'),  # Ensures 1 attempt per test
    )
    user_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    test_name = db.Column(db.String(80))
    score = db.Column(db.Integer)
    user = db.relationship('User', backref='attempts')
    timestamp = db.Column(db.DateTime, default=datetime.utcnow)